#version 330
#extension GL_EXT_gpu_shader4 : enable
//otro templo-27-03Mod01.fsh  by jorge2017a1 

//https://www.shadertoy.com/view/NsSGR1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//por jorge2017a1-
#define MAX_STEPS 100
#define MAX_DIST 100.
//#define MIN_DIST 0.001
#define MIN_DIST 0.01
#define EPSILON 0.001
//  start prevoid common  //
struct TObj
{
    float id_color;
    float id_objeto;
    float id_material;
    float dist;
    vec3 normal;
    vec3 ro;
    vec3 rd;
    vec2 uv;
    vec3 color;
    vec3 p;
    vec3 phit; //22-mar-2021
    vec3 rf;
    float marchCount;
    bool blnShadow;
    bool hitbln;
};

    
TObj mObj;
vec3 glpRoRd;
vec2 gres2;
float itime;

#define PI 3.1415926
#define pi 3.141592
#define PI2 6.28318530717
#define TriplePI (3.0 * PI)
#define DoublePI (2.0 * PI)
#define HalfPI (PI / 2.0)
#define MATERIAL_NO -1.0
#define COLOR_NO -1.0
#define COLORSKY vec3(0.1, 0.1, 0.6)


///--------------------------------------------FIN
///--------------------------------------------
vec3 hsv(vec3 c)
{
    vec4 k=vec4(1.,2./3.,1./3.,3.);
    vec3 p=abs(fract(c.xxx+k.xyz)*6.-k.www);
    return c.z*mix(k.xxx,clamp(p-k.xxx,0.,1.),c.y);
}

///Gracias a SHane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
    n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
    n /= dot(n, vec3(1)); 
    vec3 tx = texture2D(tex, p.yz).xyz;
    vec3 ty = texture2D(tex, p.zx).xyz;
    vec3 tz = texture2D(tex, p.xy).xyz;
    return ( mat3(tx*tx, ty*ty, tz*tz)*n); 
}

float random() 
{ return fract(sin(dot(mObj.uv, vec2(12.9898, 78.233)) ) * 43758.5453); }

vec3 checkerBoard(float u, float v, float interval)
{
    float uu = floor(u/interval*2.0);
    float vv = floor(v/interval*2.0);
    float p =mod(uu+vv,2.0);
    return vec3(0.1+0.9*p);
}


vec3  Arrcolores[] = vec3[] (
vec3(0,0,0)/255.0,  //0
vec3(255.,255.,255.)/255.0, //1
vec3(255,0,0)/255.0,  //2
vec3(0,255,0)/255.0,   //3
vec3(0,0,255)/255.0,   //4
vec3(255,255,0)/255.0,  //5
vec3(0,255,255)/255.0,  //6 
vec3(255,0,255)/255.0,   //7
vec3(192,192,192)/255.0,  //8
vec3(128,128,128)/255.0,  //9
vec3(128,0,0)/255.0,   //10
vec3(128,128,0)/255.0,  //11
vec3(0,128,0)/255.0,   //12
vec3(128,0,128)/255.0,  //13
vec3(0,128,128)/255.0,  //14
vec3(0,0,128)/255.0,    //15
vec3(255, 204, 188)/255.0,  //16
vec3(0.8, 0.8, 0.8),  //17
vec3(0.5, 0.5, 0.8),  //18
vec3(1, 0.5, 0),      //19
vec3(1.0, 1.0, 1.0),  //20
vec3(247./255., 168./255.,  184./255.),  //21
vec3(0, 1, 1),                           //22 
vec3(85./255., 205./255., 252./255.),    //23
vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 ),  //24 
vec3(0.8,0.8,0.8)*vec3( 0.3, 0.2, 1.0 ),       //25  
vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 ),     //26
vec3(0.1, 0.5, 1.0),                           //27   
vec3(0.0, 0.6, 0.0),                       //28 
vec3(0.1,0.1,0.7),                          //29
vec3(0.99, 0.2, 0.1), //30
vec3(.395, .95, 1.) //31
);

//----------------------------------------------------
vec3 getColor(int i)
{    
    if (i==-2 ) {return mObj.color; }       
    if (i>-1 ) 
		return Arrcolores[i];
}
///--------------------------------------------


// end prevoid common  //
vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);


vec3 light_pos1   ;
vec3 light_color1 ;
vec3 light_pos2   ;
vec3 light_color2 ;


//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )

#define opU2(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opI2(d1, d2) ( d1.x > d2.x ? d1 : d2 )
#define opS2(d1, d2) ( d1.x > -d2.x ? d1 : d2 )



float sdSphere( vec3 p, float s )
	{ return length(p)-s;}
float sdBox( vec3 p, vec3 b )
	{ vec3 d = abs(p) - b;   return length(max(d,0.0))+ min(max(d.x,max(d.y,d.z)),0.0); }
float sdCylinderYZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.yz),p.x)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXY( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xy),p.z)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }


//Hexagonal Prism - exact

float sdHexPrism( vec3 p, vec2 h )
{
  const vec3 k = vec3(-0.8660254, 0.5, 0.57735);
  p = abs(p);
  p.xy -= 2.0*min(dot(k.xy, p.xy), 0.0)*k.xy;
  vec2 d = vec2(
       length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x), h.x))*sign(p.y-h.x),
       p.z-h.y );
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

///----------Operacion de Distancia--------
float intersectSDF(float distA, float distB)
	{ return max(distA, distB);}

float unionSDF(float distA, float distB)
	{ return min(distA, distB);}

float differenceSDF(float distA, float distB)
	{ return max(distA, -distB);}
//-------------------------------------------
//----------oPeraciones de Repeticion
float opRep1D( float p, float c )
	{ float q = mod(p+0.5*c,c)-0.5*c; return  q ;}
    
///------------------------------------
// object transformation
vec3 rotate_x(vec3 p, float phi)
{
    float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{
	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}
///------------------------------------
vec2 rotatev2(vec2 p, float ang)
{
    float c = cos(ang);
    float s = sin(ang);
    return vec2(p.x*c - p.y*s, p.x*s + p.y*c);
}


float sdTriPrism( vec3 p, vec2 h )
{
  vec3 q = abs(p);
  return max(q.z-h.y,max(q.x*0.866025+p.y*0.5,-p.y)-h.x*0.5);
}


vec3 cuarto1(vec3 pp)
{	
    vec3 res;
    res = vec3(9999.0, -1.0,-1.0);
    vec3 p=pp;

    p= rotate_x(p-vec3(0.0,0.0,0.0), radians(90.0));
    float h1= sdHexPrism( p, vec2(10.0,15.0) );
     p=pp;
    float tp1= sdTriPrism( p-vec3(0.0,0.0,-8.0), vec2(5.0,20.0) );
    float b1= sdBox(p-vec3(0.0,-6.5,-8.0), vec3(4.4,5.0,20.0) );
    float dif=differenceSDF(h1,tp1);
    dif=differenceSDF(dif, b1);
    res =opU3(res, vec3(dif,100.0,MATERIAL_NO)); 
    return res;
}
    


vec3 cuarto2(vec3 pp)
{	
    vec3 res;
    res = vec3(9999.0, -1.0,-1.0);
    vec3 p=pp;

    float zdist=30.0;
    p=p-vec3(0.0,0.0,zdist);
    p= rotate_x(p, radians(90.0));
    float h1b= sdHexPrism( p, vec2(30.0,20.0) );

    p=pp;
     p=p-vec3(0.0,0.0,zdist);
    float tp1b= sdTriPrism( p-vec3(0.0,10.0,-8.0), vec2(8.0,40.0) );
    
    float b1b= sdBox(p-vec3(0.0,-2.0,-5.0), vec3(10.0,10.0,40.0) );
    
    float difb=differenceSDF(h1b,tp1b);
    difb=differenceSDF(difb, b1b);
    res =opU3(res, vec3(difb,100.0,MATERIAL_NO)); 
    
    return res;
}
 
//htps://mercury.sexy/hg_sdf/
// Shortcut for 45-degrees rotation
void pR45(inout vec2 p) {
	p = (p + vec2(p.y, -p.x))*sqrt(0.5);
}

// Repeat space along one axis. Use like this to repeat along the x axis:
// <float cell = pMod1(p.x,5);> - using the return value is optional.
float pMod1(inout float p, float size) {
	float halfsize = size*0.5;
	float c = floor((p + halfsize)/size);
	p = mod(p + halfsize, size) - halfsize;
	return c;
}
 
// The "Columns" flavour makes n-1 circular columns at a 45 degree angle:
float fOpUnionColumns(float a, float b, float r, float n) 
{
	if ((a < r) && (b < r)) {
		vec2 p = vec2(a, b);
		float columnradius = r*sqrt(2.0)/((n-1.0)*2.0+sqrt(2.0));
		pR45(p);
		p.x -= sqrt(2.0)/2.0*r;
		p.x += columnradius*sqrt(2.);
		if (mod(n,2.) == 1.) {
			p.y += columnradius;
		}
		// At this point, we have turned 45 degrees and moved at a point on the
		// diagonal that we want to place the columns on.
		// Now, repeat the domain along this direction and place a circle.
		pMod1(p.y, columnradius*2.0);
		float result = length(p) - columnradius;
		result = min(result, p.x);
		result = min(result, a);
		return min(result, b);
	} else {
		return min(a, b);
	}
}


///------------------------------------
vec3 GetDist(vec3 p  ) 
{	
	vec3 res;
    res = vec3(9999.0, -1.0,-1.0);
    
    p.z= opRep1D( p.z, 90.0 );
    
    vec3 pp=p;
    
    
	float planeDist1 = p.y+12.0;  //piso inf
    res =opU3(res, vec3(planeDist1,101.0,-1.0)); //inf
    
    vec3 c1=cuarto1(p);
    res =opU3(res, c1); 
    
    vec3 c2=cuarto2(p);
    res =opU3(res, c2); 
    
    p.y=p.y+4.5;
    p.x=abs(p.x)-15.0;
    float sc1 =sdCylinderXZ( p-vec3(0.0), vec2(2.0,35.0) );
    float sc2 =sdCylinderXZ( p-vec3(0.0,-7.0,0.0), vec2(3.0,0.5) );
    float sc3 =sdCylinderXZ( p-vec3(0.0,18.0,0.0), vec2(3.0,0.5) );
      
    float Uc1= fOpUnionColumns(sc1, sc2,  1.8,  4.0);
    Uc1= fOpUnionColumns(Uc1, sc3,  1.8,  4.0);
    
     res =opU3(res, vec3(Uc1,3.0,-1.0)); 
     
     
     vec3 p2=p;
     p2.x= abs( p2.x)-20.0;
     float box1 = sdBox(p2-vec3(0.0,-2.0,0.0), vec3(3.0,4.0,2.0) );
     float box2 = sdBox(p2, vec3(1.0,20.0,1.0) );
     box2= fOpUnionColumns(box2, box1, 1.8,  2.0);
     res =opU3(res, vec3(box2,6.0,-1.0)); 
  
   
    //return (dist, id_color, id_material)
    return res;
}



vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro) 
{
    vec3 l = lp - p;
    float dist = max(length(l), 0.01);
    float atten = min(1./(1. + dist*0.5), 0.2);
    l /= dist;
    
    vec3 n = normal;
   	vec3 r = reflect(-l, n);
    
    float dif = clamp(dot(l, n), 0.0, 1.0);
    float spe = pow(clamp(dot(r, -rd), 0.0, 1.0), 8.0);
    float fre = pow(clamp(1.0 + dot(n, rd), 0.0, 1.0), 2.0);
    float dom = smoothstep(-1.0, 1.0, r.y);
    
    vec3 lin = vec3(0.2);
    lin += 1.0*dif*vec3(1, .97, .85);
    lin += 2.5*spe*vec3(1, .97, .85)*dif;
    lin += 2.5*fre*vec3(1);
    lin += 0.5*dom*vec3(1);
    
    return lin*atten;
}

//------------------------------------------------
vec3 GetNormal(vec3 p)
{
	float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(
        GetDist(p-e.xyy).x,
        GetDist(p-e.yxy).x,
        GetDist(p-e.yyx).x);
    return normalize(n);
}

float RayMarch(vec3 ro, vec3 rd){
    float dO = 0.; 
    vec3 dS=vec3(9999.0,-1.0,-1.0);
    
    float marchCount = 0.0;
    vec3 p;
    
    #define DISTANCE_BIAS 0.75
    float minDist = 999.0; 
    
       for(int i=0; i <= MAX_STEPS; i++) 
    //for(int i=0; i<MAX_STEPS; i++) 
    {  	p = ro + rd*dO;
        dS = GetDist(p);
        /*
        if ( abs(dS.x)<MIN_DIST)
        {   mObj.hitbln = true; minDist = abs(dO); break; }
       */
        //if ( abs(dS.x)<MIN_DIST || i == MAX_STEPS-1)
        if ( abs(dS.x)<MIN_DIST  || i == MAX_STEPS)
        {   mObj.hitbln = true; minDist = abs(dO); break; }
         
        
        if(dO>MAX_DIST)
        //{ mObj.hitbln = false; minDist = min(minDist, dO);break; }
        { mObj.hitbln = false;    minDist = dO;    break; } 
        
        dO += dS.x;
        marchCount++;
         
    }
    
    mObj.dist = minDist;
    mObj.id_color = dS.y;
    mObj.marchCount=marchCount;
    mObj.id_material=dS.z;
    mObj.normal=GetNormal(p);
    mObj.phit=p;
    return dO;
}

//---------------------------------------------------
float GetShadow(vec3 p, vec3 plig)
{
    vec3 lightPos = plig;
    vec3 l = normalize(lightPos-p);
    vec3 n = GetNormal(p);
    float dif = clamp(dot(n, l), 0., 1.);
    float d = RayMarch(p+n*MIN_DIST*2., l );
    if(d<length(lightPos-p)) dif *= .1;
    return dif;
}
//----------------------------------------------------
vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{
	if (i==100 )
    { vec3 col=tex3D(iChannel0, p/32., nor); 
    return col*2.0;
    }
	if (i==101 ) { return tex3D(iChannel1, p/32., nor); }
	if (i==102 ) { return tex3D(iChannel2, p/32., nor); }
	if (i==103 ) { return tex3D(iChannel3, p/32., nor); }
}
//-------------------------------
vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos)
{
    float intensity=1.0;
     vec3 result;
     
    result = lightingv3( nor, p, plight_pos,  rd,ro)*colobj*6.0;
     
    if (mObj.blnShadow==true)
    {
    	float fhadow=GetShadow(p,plight_pos);
    	return result*fhadow;
        
     }
    else
    {  return result; }
}
///-------------------------------------

//------------------------------------------------
vec3 getMaterial( vec3 pp, float id_material)
{
  vec3 col=vec3(1.0);
  vec3 p=pp;
    
    
    if(id_material== 1.0 )
    {
        float c = 0.8+mod((floor(mObj.p.x) + floor(mObj.p.z) + floor(mObj.p.y)), 2.0);
        return vec3(1.0,0.01,0.01)*vec3( 0.3, 0.2, 1.0 )*c;
    }
    
	if(id_material== 2.0 )
    { 
        return checkerBoard(mObj.p.x, mObj.p.z, 3.0);
    } 
    
	if(id_material== 3.0 )
    { 
        return checkerBoard(mObj.p.x, mObj.p.z, 3.0)*vec3(0.425, 0.56, 0.9)*vec3( 0.3, 0.2, 1.0 );
    } 

    if (id_material==4.0)
    { // nothing hit: background gradient
     return vec3(0.2, 0.2, 0.2) * (-mObj.uv.y+1.2);
    }
    
    if (id_material==5.0)
    {
        float escala=0.25;
    	float d = mod(floor(p.x*escala)+floor(p.z*escala*2.0),2.0);
	    return vec3( clamp(d,0.0,1.0) );
    }
    
    
    
}
//-------------------------------------------------

vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material)
{
   	vec3 colobj; 
    if (id_color<100)
		{ colobj=getColor(int( id_color)); }
    
    
    if ( float( id_color)>=100.0  && float( id_color)<=199.0 ) 
 	{  vec3 coltex=getColorTextura(p, n, int( id_color));
        colobj=coltex;
	}

    if (id_material>-1.0 && id_color==-1)
        { 
            colobj=vec3(0.5);
            colobj*=getMaterial(p, id_material); 
            return colobj;
        }
    return colobj;
}

vec3 getSkyColA(vec3 rd) 
{
    float t = (rd.x + 1.0) / 2.0;
    return vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
}

///---------------------------------------------
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
   mObj.uv=uv;
    float t;
    t=mod(iTime*5.0,360.0);
    itime=t;
	//mObj.blnShadow=false;
    mObj.blnShadow=true;
        
 	light_pos1= vec3(0.0, 3.0, 5.0 );  light_color1 =1.25*vec3( 1.0 ,0.1,0.1);
 	light_pos2= vec3( -5.0, 6.0, -5.0 ); light_color2 =1.25* vec3( .1 ,0.1,1.0); //light_color1; //vec3( 1.0, 1.0, 1.0 );
 
    
    vec3 ro=vec3(0.0,-2.0,-25.0+t);
     vec3 rd=normalize(vec3(uv,1.0));
    
    
    light_pos1+=ro;
    light_pos2+=ro;
    
    
    vec3 col = vec3(0);
    TObj Obj;
    mObj.rd=rd;  mObj.ro=ro;
    
    float d = RayMarch(ro, rd);
    Obj=mObj;
    if(mObj.hitbln) 
    {
        vec3 p = (ro + rd * d ); 
        mObj.p=p;
        mObj.dist =d;
        vec3 nor=mObj.normal;

        vec3 colobj;
        colobj=GetColorYMaterial( p, nor, ro, rd,  int( Obj.id_color), Obj.id_material);

        float dif1=1.0;
        vec3 result;
        result=  Getluz( p,ro,rd, nor, colobj ,light_pos1);
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2);
        result/=1.25;
        col= result*dif1;
        /*
        //sugerencia por dean_the_coder,
        //col *= 1.0 - pow(d / 100.0, 1.5);
        col *= 1.0 - pow(d /(MAX_DIST) , 3.5);    
        col = pow(col, vec3(1.0/2.2));
        */
        
         //sugerencia por ocb,
        col = pow(col, vec3(1.0/2.2));
        col = mix(col, getSkyColA(rd), min(1.,.01*d));   // fading with sky color depending on the distance


    }
    else if(d>MAX_DIST)
     col= getSkyColA(rd);
    
    
    gl_FragColor = vec4(col,1.0);
}